#pragma rtGlobals=1		// Use modern global access method.
#pragma rtGlobals=2		// Use modern global access and logic ops
#include  <All IP Procedures>
#include  <Image Saver>
#include  <FITS Loader>

function LoadNeoFITS()
	
	NewPath CF
	variable refnum
	string fn=IndexedFile(CF,-1,".tif" )
	string Wsub
	string temp
	
	variable i,j

	for(i=0;i<ItemsInList(fn);i+=1)	

//		do
			Wsub=stringfromlist(i,fn)
//			i+=1
//		while(strsearch(Wsub,"Sub.tif",1)==-1 && i < ItemsInList(fn) )
//		i=i-1
				
		if( i==ItemsInlist(fn) && strsearch(Wsub,"Sub.tif",1)!=1)
			break
		else
			
			j=-1
			do
				j=j+1
			while(stringmatch(wsub,stringfromlist(j,wavelist("*",";","")))!=1 && j<ItemsInList(wavelist("*",";","")))				
			
			if(j!=ItemsInList(wavelist("*",";","")))
				continue	
			endif	
			
			open/R/P=CF/T="????" refnum as Wsub
		
			variable Nx,Ny,Nz
	
			string s=padstring("",80,0)
		
			do
				FBinRead refnum,s
			while(cmpstr("BITPIX",s[0,5]) != 0)	
		
			variable BitPix=str2num(s[10,29])
			variable numbertype
		
			switch(BitPix)
				case 8:
					numberType= 8+0x40
				break
				case 16:
					numberType= 0x10
				break
				case 32:
					numberType= 0x20
				break
				case -32:
					numberType= 2
				break
				case -64:
					numberType= 1
				break			
			endswitch
				
			do	
				FBinRead refnum,s
			while(cmpstr("NAXIS1",s[0,5]) != 0)	
			Nx= str2num(s[10,29])
	
			do	
				FBinRead refnum,s
			while(cmpstr("NAXIS2",s[0,5]) != 0)	
			Ny= str2num(s[10,29])

			do
				FBinRead refnum,s
			while(cmpstr("NAXIS3",s[0,5]) != 0)	
			Nz= str2num(s[10,29])

			make/Y=(NumberType)/O/n=(Nx,Ny,Nz) data
			
			do
				FBinRead refnum,s
			while(cmpstr("KCT ",s[0,3]) != 0)
			
			sprintf temp,"\rKinetic Cycle Time : %g", numberbykey("KCT     ",s,"=")
			note data, temp

			do
				FBinRead refnum,s
			while(cmpstr("EXPOSURE",s[0,7]) != 0)
						
			sprintf temp,"Exposure Time       : %g", numberbykey("EXPOSURE",s,"=")
			note data, temp

			do
				FBinRead refnum,s
			while(cmpstr("READTIME",s[0,7]) != 0)
			
			if(numberbykey("READTIME",s,"=") == 5e-09)
				sprintf temp,"Read out mode : 200 MHz"
				note data, temp			
			else
				sprintf temp,"Read out mode : 560 MHz"
				note data, temp				
			endif
			
			do
				FBinRead refnum,s
			while(cmpstr("PREAMP ",s[0,6]) != 0)
			
			variable PreAmp = numberbykey("PREAMP  ",s,"=")
			switch(PreAmp)				
				case 1:
					sprintf temp,"Sensitivity/Dynamic range : 11 bit (High well capacity)"
					note data, temp					
				break
				case 2:
					sprintf temp,"Sensitivity/Dynamic range : 11 bit (Low noise)"
					note data, temp	
				break
				case 3:
					sprintf temp,"Sensitivity/ Dynamic range : 16 bit (Low noise and high well capacity)"
					note data, temp					
				break
			endswitch
	
			do
				FBinRead refnum,s
			while(cmpstr("End ",s[0,3]) != 0)
		
			FStatus refnum
			variable  nextRec= ceil(V_filePos/2880)*2880
			FSetPos refnum,nextRec
	
			FBinRead/B=2 refnum,data
		
			rename data, $Wsub
		
			close refnum	
		endif			
	endfor
end

Function AcqZStack()
//	VARIABLE N_Frames
	
	string aL=Wavelist("TL*",";","")
	variable i
	
	for(i=0;i<ItemsInList(aL);i+=2)
		wave/Z w=$StringFromList(i,aL)
		
		Duplicate/O/R=[][][1,4] w, BGtemp
		Duplicate/O/R=[][][7,9] w, StimTemp
		
		Redimension/N=(-1,-1,0) BGtemp,StimTemp
		Wave Solution= WaveCalculatorW(1,StimTemp,BGtemp)
		concatenate/NP=2/KILL {Solution}, DF_Stack
	
	endfor
	
	for(i=i-1;i>=1;i-=2)
		wave/Z w=$StringFromList(i,aL)

		if(waveexists(w)==0)
			continue
		endif
		
		Duplicate/O/R=[][][1,4] w, BGtemp
		Duplicate/O/R=[][][7,9] w, StimTemp
		
		Redimension/N=(-1,-1,0) BGtemp,StimTemp
		Wave Solution= WaveCalculatorW(1,StimTemp,BGtemp)
		concatenate/NP=2/KILL {Solution}, DF_Stack
	
	endfor
	
	KillWaves BGTemp, StimTemp	
	
	
End


Function GetDFiImagein3Dwave()
	
	string aw=wavelist("*",";","")
	variable i
	string RestName
	string DepName
	string RName
	
	for(i=0;i<ItemsInList(aw);i+=1)
		wave w=$stringfromlist(i,aw)	
		RestName=NameOfWave(w)+"_Rt"
		DepName=NameOfWave(w)+"_DF"
		RName=NameOfWave(w)+"_Ratio"
		wave ImRest = Partial3DWaveAvg(w,1,5)
		rename Imrest,$RestName
		wave ImWr=$RestName
		wave ImDep = Partial3DWaveAvg(w,7,11)
		rename ImDep,$DepName
		wave ImWd=$DepName
		ImWD = ImWD-ImWr
		Duplicate ImWD, $RName
		wave ImWratio = $RName
		ImWratio = ImWD/ImWr
	endfor
	
	string RestW=wavelist("*Rt",";","")
	string DFW=	wavelist("*DF",";","")
	string RFW=	wavelist("*Ratio",";","")
	DFREF home=getdatafolderdfr()
	newdatafolder/S Rest
	DFREF RestF=getdatafolderdfr()
	setdatafolder home
	newdatafolder/S DeltaF
	DFREF DFF=getdatafolderdfr()
	setdatafolder home
	newdatafolder/S Ratio
	DFREF RatioF=getdatafolderdfr()
	setdatafolder home
	for(i=0;i<itemsInList(RestW);i+=1)
		wave w=$StringFromList(i,RestW)
		movewave w, RestF:$NameOfwave(w)
	endfor
	
	for(i=0;i<itemsInList(DFW);i+=1)
		wave w=$StringFromList(i,DFW)
		movewave w, DFF:$NameOfWave(w)
	endfor
	
	for(i=0;i<itemsInList(RFW);i+=1)
		wave w=$StringFromList(i,RFW)
		movewave w, RatioF:$NameOfWave(w)
	endfor
end

Function FileDividerEasy()
	string aw=wavelist("*",";","")
	variable n=ItemsInList(aw)
	variable i
	
	for(i=0;i<n;i+=2)
		wave w=$stringfromlist(i,aw)
		concatenate/NP=2 {w},Stack_Image
		killwaves w			
	endfor

	aw=wavelist("*",";","")
	n=ItemsInList(aw)
	
	for(i=n-2;i>=0;i-=1)
		wave w=$stringfromlist(i,aw)
		concatenate/NP=2 {w},Stack_Image
		killwaves w			
	endfor			

end